#!/bin/sh
#

BASH_BASE_SIZE=0x00001a0e
CISCO_AC_TIMESTAMP=0x0000000061b09222
CISCO_AC_OBJNAME=iseposture_install.sh                                           
# BASH_BASE_SIZE=0x00000000 is required for signing
# the comment is after or else the code signing tool will find the comment

version() { echo "$@" | awk -F. '{ printf("%d%03d%05d\n", $1,$2,$3); }'; }

ANYCONNECT_INSTPREFIX="/opt/cisco/anyconnect"
ANYCONNECT_BINDIR="${ANYCONNECT_INSTPREFIX}/bin"
ANYCONNECT_LIBDIR="${ANYCONNECT_INSTPREFIX}/lib"
ANYCONNECT_PLUGINDIR="${ANYCONNECT_BINDIR}/plugins"
ISEPOSTURE_PROFILEDIR="${ANYCONNECT_INSTPREFIX}/iseposture"
ISEPOSTURE_SCRIPTDIR="${ISEPOSTURE_PROFILEDIR}/scripts"

ISEBINFILES="aciseposture aciseagentd iseposture_uninstall.sh manifesttool_iseposture"
ISELIBFILES="libacise.so"
ISEPLUGINFILES="libacisectrl.so libaciseshim.so"
ISEPOSTUREMANIFEST="ACManifestISEPosture.xml"
VPNMANIFEST="${ANYCONNECT_INSTPREFIX}/ACManifestVPN.xml"

LOGFNAME=`date "+anyconnect-linux64-4.10.04071-iseposture-%H%M%S%d%m%Y.log"`
CLIENTNAME="Cisco AnyConnect ISE Posture Module"
CURRENTDIR=`dirname $0 2> /dev/null`

INST_BINDIR="${CURRENTDIR}/bin"
INST_PLUGINDIR="${INST_BINDIR}/plugins"
INST_LIBDIR="${CURRENTDIR}/lib"

ARG_NO_LICENSE=0

if [ "x$1" = "x--no-license" ]; then
    ARG_NO_LICENSE=1
fi

echo "Installing ${CLIENTNAME}..."
echo "Installing ${CLIENTNAME}..." > /tmp/${LOGFNAME}
echo `whoami` "invoked $0 from " `pwd` " at " `date` >> /tmp/${LOGFNAME}

# Check for root privileges
if [ `id | sed -e 's/(.*//'` != "uid=0" ]; then
  echo "Sorry, you need super user privileges to run this script."
  echo "Sorry, you need super user privileges to run this script." >> /tmp/${LOGFNAME}
  exit 1
fi

# ISE Posture requires VPN to be installed. We check the presence of the vpn manifest file to check if it is installed.
if [ ! -f ${VPNMANIFEST} ]; then
    echo "VPN should be installed before ISE Posture installation. Install VPN to proceed."
    echo "Exiting now."
    echo "VPN should be installed before ISE Posture installation. Install VPN to proceed." >> /tmp/${LOGFNAME}
    echo "Exiting now." >> /tmp/${LOGFNAME}
    exit 1
fi

failed=false
# version of ise posture being installed has to be same as installed VPN version
if [ -f "${CURRENTDIR}/${ISEPOSTUREMANIFEST}" ] && [ -f ${VPNMANIFEST} ]; then
    VPNVERSION=$(awk -F"\"" '/file version/ { print $2 }' ${VPNMANIFEST})
    ISECURRVERSION=$(awk -F"\"" '/file version/ { print $2 }' ${CURRENTDIR}/${ISEPOSTUREMANIFEST})

    if [ $(version $VPNVERSION) -ne $(version $ISECURRVERSION) ]; then
     failed=true
    fi
fi

if [ "$failed" = true ]; then
    echo "Please use ise posture installer from Anyconnect package with version ${VPNVERSION} for the installation"
    echo "Please use ise posture installer from Anyconnect package with version ${VPNVERSION} for the installation" >> /tmp/${LOGFNAME}
    echo "Exiting now."
    echo "Exiting now." >> /tmp/${LOGFNAME}
    exit 1
fi

if [ "x${ARG_NO_LICENSE}" = "x1" ]; then
    echo "Skipping license text ..."
else
    if [ -f "license.txt" ]; then
        cat ./license.txt
        echo
        echo -n "Do you accept the terms in the license agreement? [y/n] "
        read LICENSEAGREEMENT
        while :
        do
          case ${LICENSEAGREEMENT} in
               [Yy][Ee][Ss] | [Yy])
                       echo "You have accepted the license agreement."
                       echo "Please wait while ${CLIENTNAME} is being installed..."
                       break
                       ;;
               [Nn][Oo] | [Nn])
                       echo "The installation was cancelled because you did not accept the license agreement."
                       echo "The installation was cancelled because you did not accept the license agreement." >> /tmp/${LOGFNAME}
                       exit 1
                       ;;
               *)
                       echo "Please enter either \"y\" or \"n\"."
                       read LICENSEAGREEMENT
                       ;;
          esac
        done
    else
        echo "License file not found. Aborting installation."
        echo "License file not found. Aborting installation." >> /tmp/${LOGFNAME}
        exit 1
    fi
fi
if [ -x "/usr/bin/install" ]; then
    INSTALL="/usr/bin/install"
elif [ -x "/bin/install" ]; then
    INSTALL="/bin/install"
elif [ -x "/usr/local/bin/install" ]; then
    INSTALL="/usr/local/bin/install"
else
    INSTALL="install"
fi

${INSTALL} --help 2> /dev/null > /dev/null
if [ $? != 0 ]; then
    INSTALL=""
fi

echo "Creating directories... "
echo "Creating directories... " >> /tmp/${LOGFNAME}

if [ "x${INSTALL}" = "x" ]; then
    echo "Unable to find install command. Aborting installation."
    echo "Unable to find install command. Aborting installation." >> /tmp/${LOGFNAME}
    exit 1
fi

# Make sure destination directories exist
echo "Installing "${ANYCONNECT_BINDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${ANYCONNECT_BINDIR} || exit 1
echo "Installing "${ANYCONNECT_LIBDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${ANYCONNECT_LIBDIR} || exit 1
echo "Installing "${ANYCONNECT_PLUGINDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${ANYCONNECT_PLUGINDIR} || exit 1
echo "Installing "${ISEPOSTURE_PROFILEDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${ISEPOSTURE_PROFILEDIR} || exit 1
echo "Installing "${ISEPOSTURE_SCRIPTDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${ISEPOSTURE_SCRIPTDIR} || exit 1

echo "done."
echo "done." >> /tmp/${LOGFNAME}

echo "Copying files... "
echo "Copying files... " >> /tmp/${LOGFNAME}

for f in ${ISEBINFILES}; do
    echo "Installing "${INST_BINDIR}/$f >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${INST_BINDIR}/$f ${ANYCONNECT_BINDIR} || exit 1
done

for f in ${ISELIBFILES}; do
    echo "Installing "${INST_LIBDIR}/$f >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${INST_LIBDIR}/$f ${ANYCONNECT_LIBDIR} || exit 1
done

for f in ${ISEPLUGINFILES}; do
    echo "Installing "${INST_PLUGINDIR}/$f >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${INST_PLUGINDIR}/$f ${ANYCONNECT_PLUGINDIR} || exit 1
done

echo "done."
echo "done." >> /tmp/${LOGFNAME}

# update manifest
echo "Updating AC manifest." >> /tmp/${LOGFNAME}

${INSTALL} -o root -m 755 ${CURRENTDIR}/${ISEPOSTUREMANIFEST} ${ANYCONNECT_INSTPREFIX} >> /tmp/${LOGFNAME}
${INST_BINDIR}/manifesttool_iseposture -i ${ANYCONNECT_INSTPREFIX} ${ANYCONNECT_INSTPREFIX}/${ISEPOSTUREMANIFEST} >> /tmp/${LOGFNAME}

echo "done."
echo "done." >> /tmp/${LOGFNAME}

echo "${CLIENTNAME} is installed successfully."
echo "${CLIENTNAME} is installed successfully." >> /tmp/${LOGFNAME}

# move the logfile out of the tmp directory
mv /tmp/${LOGFNAME} ${ANYCONNECT_INSTPREFIX}/.

exit 0


  +S!cV!j!dqeayIVDMPT!A!kfkjvddSBJJJ!V!eznRGBF <080 SG!_+0
	*H
 0r10	UUS10U
DigiCert Inc10Uwww.digicert.com110/U(DigiCert SHA2 Assured ID Code Signing CA0
210317000000Z
240321235959Z0v10	UUS10U
Massachusetts10U
Boxborough10U
Cisco Systems, Inc.10UCisco Systems, Inc.0"0
	*H
  0
 t27)7%}XA1%'%WR<_vE(NWˏq-ax.$y@t˕-NkkkJq{.{9YyrBИ
Tk{L=%z P66{ x&/jR؟ 
+t<7h[Xh㤹hsi[etvRZa6=QV 00U#0ZĹ{*
q`-euX0U:ov݈4[H0U0U%0
+0wUp0n0531/http://crl3.digicert.com/sha2-assured-cs-g1.crl0531/http://crl4.digicert.com/sha2-assured-cs-g1.crl0KU D0B06	`Hl0)0'+http://www.digicert.com/CPS0g0+x0v0$+0http://ocsp.digicert.com0N+0Bhttp://cacerts.digicert.com/DigiCertSHA2AssuredIDCodeSigningCA.crt0U0 0
	*H
  !laia<5ߛW	긎F~7֝ SIe6AYb<$!6)ApD>ˋEyh
SVz$w9VFZ3>
/3N
- AT#sNˡzU|&ιkvlH2}.G4QFꁇmz~W
]
AS/k*Sr9B\Q8n(R!8QUbʥXGi8Ofk9y7 4000	_ջfuSCoP0
	*H
 0e10	UUS10U
DigiCert Inc10Uwww.digicert.com1$0"UDigiCert Assured ID Root CA0
131022120000Z
281022120000Z0r10	UUS10U
DigiCert Inc10Uwww.digicert.com110/U(DigiCert SHA2 Assured ID Code Signing CA0"0
	*H
  0
 ӳgw1IE:D娝2qv.C7׶𜆥%y(:~g)'{##w#fT3Pt(&$iRgE-, JM`Ĳp1f3q>p|˒;1
WJt+l~t96
Nj
gN %#d>RŎ,QsbsA8js ds<3% 00U0 0U0U%0
+0y+m0k0$+0http://ocsp.digicert.com0C+07http://cacerts.digicert.com/DigiCertAssuredIDRootCA.crt0Uz0x0:864http://crl4.digicert.com/DigiCertAssuredIDRootCA.crl0:864http://crl3.digicert.com/DigiCertAssuredIDRootCA.crl0OU H0F08
`Hl 0*0(+https://www.digicert.com/CPS0
`Hl0UZĹ{*
q`-euX0U#0E뢯˂1-Q!m0
	*H
  >
Z$",|%)v]-:0a~`=į* U7ђuQnZ^$N?qcK_Dy6FN\Q$$'*)(:q(<.%Gzhh\ \qh@@Dd%B26$/r~IEYtdkfCڳ
 Ι1c=OƓIbnS.hlD2fdQ  cUQ<JATT
U]g Kh&IDH^\G2fcdL
5R]
iv1$$RY2q
Sv8Ђ>69&o
	*UȜǉ{|=hփ7]X\1~ofNڔ7<:>-JRADÏmFPAP9y
~ZUfYH
p!JD߳X~02VC||Pp^9|d  wb.WVͯ1a=:bE4Sq&ׯ+gl`}~WU#$N;w?"FքW^ic~%]~V)"zoH02D. oSmZu`(pz-)e
(MQ*BЪGz/gnMIIi+z'3x %`ا6; 8'qA˲k|1d~\狘ᆘ퐽l